load row
load validx
load validy
load i

%%%% Processing

NumberOfPoints = row;

% X und Y Werte ine ein File schreiben
k=1;
for j=1:1:NumberOfPoints
    results(k,:) = validx(j,:);
    results(k+1,:) = validy(j,:);
    k=k+2;
end

% Mittelwerte fr X und Y jeweils berechnen
for g=1:1:i
   average_results_x(g) = mean(validx(:,g));
   average_results_y(g) = mean(validy(:,g));
end

% Resultate um Mittelwerte korrigieren (x)
for j=1:2:2*NumberOfPoints-1
    temp = results(j,1)-average_results_x(1);
    for g=1:1:i
      corrected_results(j,g) = results(j,g)-average_results_x(g);
      corrected_results(j,g) = corrected_results(j,g)-temp;
    end
end

% Resultate um Mittelwerte korrigieren (y)
for j=2:2:2*NumberOfPoints
    temp = results(j,1)-average_results_y(1);
    for g=1:1:i
      corrected_results(j,g) = results(j,g)-average_results_y(g);
      corrected_results(j,g) = corrected_results(j,g)-temp;
    end
end

% Distanz bzw. Auslenkung vom Anfangsort ausrechnen
k=1
for j=1:1:NumberOfPoints
    for h=1:1:i
       distance(j,h) = sqrt(corrected_results(k,h)^2+corrected_results(k+1,h)^2);
    end
k=k+2;
end

%%%%

PointsPerBeam = NumberOfPoints/4;
for j = 1:1:4
    for g=1:1:i
        distance_mean(j,g) = mean(distance(j*PointsPerBeam-PointsPerBeam+1:j*PointsPerBeam,g));
    end
end


%%% Plot
figure
hold on
for j=1:2:2*NumberOfPoints
    plot(corrected_results(j,:), corrected_results(j+1,:))
end
hold off

figure
hold on
for j=1:1:NumberOfPoints
    plot(distance(j,:))
end
hold off

figure
hold on
for j=1:1:4
    plot(distance_mean(j,:))
end
hold off